<?php
/*
 * Plugin Name: WooCommerce Noqoodypay Payment Gateway
 * Description: Take payments on your store.
 * Author: Machhindra Zankar
 * Author URI: http://mapwebtechnologies.com
 * Version: 1.0.1
 *
 /*
 * This action hook registers our PHP class as a WooCommerce payment gateway
 */
add_filter( 'woocommerce_payment_gateways', 'noqoodypay_add_gateway_class' );
function noqoodypay_add_gateway_class( $gateways ) {
	$gateways[] = 'WC_Noqoodypay_Gateway'; // your class name is here
	return $gateways;
}

//define clictopay payment padge location
define('noqoodypay_imgdir', WP_PLUGIN_URL . "/" . plugin_basename(dirname(__FILE__)) . '/images/');
	 
/*
 * The class itself, please note that it is inside plugins_loaded action hook
 */
add_action( 'plugins_loaded', 'noqoodypay_init_gateway_class' );
function noqoodypay_init_gateway_class() {
 
	class WC_Noqoodypay_Gateway extends WC_Payment_Gateway {
 
 		/**
 		 * Class constructor, more about it in Step 3
 		 */
 		public function __construct() {
 
			$this->id 	= 'noqoodypay'; // payment gateway plugin ID
			$this->icon = noqoodypay_imgdir . 'logo.png'; // URL of the icon that will be displayed on checkout page near your gateway name
			$this->has_fields = true; // in case you need a custom credit card form
			$this->method_title = 'NoqoodyPay Gateway';
			$this->method_description = 'Description of NoqoodyPay payment gateway'; // will be displayed on the options page
		 
			// gateways can support subscriptions, refunds, saved payment methods,
			// but in this tutorial we begin with simple payments
			$this->supports = array(
				'products'
			);
		 
			// Method with all the options fields
			$this->init_form_fields();
		 
			// Load the settings.
			$this->init_settings();
			
			// Get setting values
			foreach ( $this->settings as $key => $val ) $this->$key = $val;
			
			if ( $this->testmode == "yes" ) {
				$this->token_url			= 	'https://sandbox.noqoodypay.com/sdk/token';//'http://sandbox.noqoodypay.com/api/token'; // test url
				$this->payment_link_url		= 	'https://sandbox.noqoodypay.com/sdk/api/PaymentLink/GenerateLinks'; // test url
				$this->trans_details_url	= 	'https://sandbox.noqoodypay.com/sdk/api/Members/GetTransactionDetailStatusByClientReference/'; // test url
				$this->npay_username		=	$this->test_username;
				$this->npay_password		=	$this->test_password;
				$this->npay_project_code	=	$this->test_project_code;
				$this->npay_secret_key		=	$this->test_secret_key;
				
			} else {
				$this->token_url 			= 'https://noqoodypay.com/sdk/token'; // live url
				$this->payment_link_url		= 'https://noqoodypay.com/sdk/api/PaymentLink/GenerateLinks/'; // live url
				$this->trans_details_url	= 'https://noqoodypay.com/sdk/api/Members/GetTransactionDetailStatusByClientReference/'; // live url
				$this->npay_username		=	$this->live_username;
				$this->npay_password		=	$this->live_password;
				$this->npay_project_code	=	$this->live_project_code;
				$this->npay_secret_key		=	$this->live_secret_key;
			}
			
		 
			// This action hook saves the settings
			add_action( 'woocommerce_update_options_payment_gateways_' . $this->id, array( $this, 'process_admin_options' ) );
		 
			// We need custom JavaScript to obtain a token
			//add_action( 'wp_enqueue_scripts', array( $this, 'payment_scripts' ) );
		 
			// You can also register a webhook here
			// add_action( 'woocommerce_api_{webhook name}', array( $this, 'webhook' ) );	
 			add_action('init', array(&$this, 'check_noqoodypay_response'));
			//update for woocommerce >2.0
			add_action( 'woocommerce_api_' . strtolower( get_class( $this ) ), array( $this, 'check_noqoodypay_response' ) );
			add_action('woocommerce_receipt_noqoodypay', array(&$this, 'receipt_page'));
 		}
 
		/**
 		 * Plugin options, we deal with it in Step 3 too
 		 */
 		public function init_form_fields(){
				$returnUrl 		= 	WC()->api_request_url('WC_Noqoodypay_Gateway');
				
				//For wooCoomerce 2.0
				/*if ( version_compare( WOOCOMMERCE_VERSION, '2.0.0', '>=' ) ) {
					$returnUrl = add_query_arg( 'wc-api', get_class( $this ), $returnUrl );
				}*/
				
				$this->form_fields = array(
				'enabled' => array(
					'title'       => 'Enable/Disable',
					'label'       => 'Enable Noqoodypay Gateway',
					'type'        => 'checkbox',
					'description' => '',
					'default'     => 'no'
				),
				'title' => array(
					'title'       => 'Title',
					'type'        => 'text',
					'description' => 'This controls the title which the user sees during checkout.',
					'default'     => 'Noqoodypay',
					'desc_tip'    => true,
				),
				'description' => array(
					'title'       => 'Description',
					'type'        => 'textarea',
					'description' => 'This controls the description which the user sees during checkout.',
					'default'     => 'Pay with Noqoodypay via our super-cool payment gateway.',
				),
				'call_back_url' => array(
					'title'       => 'Callback URL',
					'type'        => 'title',
					'description' => '<b>'.$returnUrl.'?</b><br> Please add this URL at noqoody admin.',
					'default'     => '',
				),
				'testmode' => array(
					'title' 		=> __('TEST Mode', 'cc'),
					'type' 			=> 'checkbox',
					'label' 		=> __('Enable TEST Transactions.', 'cc'),
					'default' 		=> 'no',
					'description' 	=> __('Tick to run TEST Transactions.'),
					'desc_tip' 		=> true
				),
				'test_options' => array(
					'title'       => __( 'Test Details', 'woocommerce' ),
					'type'        => 'title',
					'description' => '',
				),
				'test_username' => array(
					'title'       => 'Username',
					'type'        => 'text'
				),
				'test_password' => array(
					'title'       => 'Password',
					'type'        => 'password'
				),
				'test_project_code' => array(
					'title'       => 'Project Code',
					'type'        => 'text',
					'description' 	=> __('Your project code provided by noqoody admin')
				),
				'test_secret_key' => array(
					'title'       => 'Secret Key',
					'type'        => 'text',
					'description' 	=> __('Your secret key provided by noqoody admin')
				),
				'live_options' => array(
					'title'       => __( 'Live Details', 'woocommerce' ),
					'type'        => 'title',
					'description' => '',
				),
				'live_username' => array(
					'title'       => 'Username',
					'type'        => 'text'
				),
				'live_password' => array(
					'title'       => 'Password',
					'type'        => 'password'
				),
				'live_project_code' => array(
					'title'       => 'Project Code',
					'type'        => 'text',
					'description' 	=> __('Your project code provided by noqoody admin')
				),
				'live_secret_key' => array(
					'title'       => 'Secret Key',
					'type'        => 'text',
					'description' 	=> __('Your secret key provided by noqoody admin')
				)			
			);
 
	 	}
 		private function get_access_token()
		{
			$request_headers = array();
			$request_headers[] = 'Accept: application/x-www-formURLencoded';
			
			$fields_string	=	'';
			$args = array('grant_type' => 'password',
				'username' => $this->npay_username,
				'password' => $this->npay_password
				);
				
				foreach($args as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
				rtrim($fields_string, '&');
			
			// Performing the HTTP request
			$ch = curl_init($this->token_url);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $request_headers);
			curl_setopt($ch,CURLOPT_POST, count($args));
			curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			//curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
			//curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
				
			$response_body 	= 	curl_exec($ch); // Performs the Request, with specified curl_setopt() options (if any).			
			if($response_body != '')
			{
				$arr_reponse	=	json_decode($response_body,true);
				if(is_array($arr_reponse) && $arr_reponse['access_token'] != '')
				return $arr_reponse['access_token'];
			}
			return '';
		}
		
		public function validate_fields() 
		{
			return true;
        }

		public function payment_fields(){
?>
                <fieldset>
	                        <p class="form-row form-row-wide">
	                <label for="<?php echo $this->id; ?>-admin-note"><?php echo ($this->description); ?> <span class="required">*</span></label>
	                <?php if($this->hide_text_box !== 'yes'){ ?>
	                                    <textarea id="<?php echo $this->id; ?>-admin-note" class="input-text" type="text" name="<?php echo $this->id; ?>-admin-note"></textarea>
                <?php } ?>
                        </p>                                           
                        <div class="clear"></div>
                </fieldset>
                <?php
	        }
		
		
		/**
	     * Output for the order received page.
	    **/
		public function receipt_page( $order_id ) {

			global $woocommerce;
			$order = new WC_Order( $order_id );
			$txnid = $order_id.'_'.date("ymdhis");
			
			echo '<p>Thank you for your order, please select payment method & click the button below to pay using NoqoodyPay.</p>';
			
			$access_token	=	$this->get_access_token();
			if($access_token == '')
			{
				//echo wpautop( wp_kses_post( "Error in creating token.Please contact site admin!" ) );
				echo '<div id="noqoodypay">'.wpautop( wp_kses_post( "Error in creating token.Please contact site admin!" ) ).'<a class="button cancel" href="' . esc_url( $order->get_cancel_order_url() ) . '">Cancel order &amp; restore cart</a></div>';
			}
			else
			{		
				$get_payment_link_url	=	$this->payment_link_url.$this->npay_project_code;
				$unq_ref_no		=	$order_id.'_'.time();
				$description	=	"Woocommerce-Order";
				$amount			=	$order->order_total;	
				
				$CustomerName	=	$order->billing_first_name.' '.$order->billing_last_name;			
				$CustomerEmail	=	$order->billing_email;
				$CustomerMobile	=	$order->billing_phone;
				$ProjectCode	=	$this->npay_project_code;
				$SecretKey		=	$this->npay_secret_key;
				$string         =   $CustomerEmail.$CustomerName.$CustomerMobile.$description.$ProjectCode.$unq_ref_no; 
				$sig            =   base64_encode(hash_hmac('sha256', $string, $SecretKey, true));
				//die;
				/*$fields_string	=	'';
				$args = array('reference' => $unq_ref_no,
					'description' => $description,
					'amount' => $amount,
					'CustomerEmail' => $order->billing_email,
					'CustomerMobile' => $order->billing_phone,
					'CustomerName' => $order->billing_first_name.' '.$order->billing_last_name
					);
		
				foreach($args as $key=>$value) { $fields_string .= $key.'='.urlencode($value).'&'; }
				rtrim($fields_string, '&');
				
				$context = stream_context_create(array(
					'http' => array(
						'header'  => "Authorization: Bearer " . $access_token
					)
				));				
				$pmt_lnk_data	= 	@file_get_contents($get_payment_link_url.'?'.$fields_string, false, $context);	
				*/	
				
				$fields_string	=	'';
				$args = array(
					'ProjectCode'    => $ProjectCode,
					'Description'    => $description,
					'Amount'         => $amount,
					'CustomerEmail'  => $CustomerEmail,
					'CustomerMobile' => $CustomerMobile,
					'CustomerName'   => $CustomerName,
					'SecureHash'     => $sig,
					'Reference'      => $unq_ref_no
				);
				foreach($args as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
				$fields_string = rtrim($fields_string, '&');
				
				$request_headers   = array();
				$request_headers[] = 'Accept: application/x-www-formURLencoded';
				$request_headers[] = 'Authorization: Bearer ' . $access_token;
				// Performing the HTTP request
				$ch = curl_init($this->payment_link_url);
				curl_setopt($ch, CURLOPT_HTTPHEADER, $request_headers);
				curl_setopt($ch,CURLOPT_POST, count($args));
				curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
					
				$response_body 	= 	curl_exec($ch); // Performs the Request, with specified curl_setopt() options (if any).	
				$response_err 	= 	curl_error($ch);
				$arr_reponse	=   "";
				$pmt_lnk		=	'';	
				/*echo '<pre>';
				print_r($args);
				print_r($request_headers);
				print_r($response_err);
				print_r($response_body);
				echo '</pre>';//die;*/
				if($response_body != '')
				{
					$arr_reponse	=	json_decode($response_body,true);
					if(is_array($arr_reponse) && $arr_reponse['PaymentUrl'] != '')
						$pmt_lnk	=	$arr_reponse['PaymentUrl'];
				}
					
				if($pmt_lnk != '')
				{
					echo '<input type="hidden" value="'.$pmt_lnk.'" id="redirect_url">';
					echo '<input type="button" name="Pay_Now" value="Pay Now" class="button alt" id="eazypay-payment-button" onclick="return check_payment_form();"></div>';
						
						?>
					<script>
                        function check_payment_form()
                        {
                            var redirect_uri	=	document.getElementById("redirect_url").value;
                            if(redirect_uri == '')
                            {
                                alert("Please select payment option");
                                return false;
                            }
                            location.href	=	redirect_uri;
                            return true;
                        }
                        function add_action(frm_action)
                        {
                            document.getElementById("redirect_url").value	=	frm_action;
                        }
						check_payment_form();
                    </script>	
                        <?php	
				}
				else
				{
					echo '<div id="noqoodypay">'.wpautop( wp_kses_post( "Error in fetching payment links.Please contact site admin!" ) ).'<a class="button cancel" href="' . esc_url( $order->get_cancel_order_url() ) . '">Cancel order &amp; restore cart</a></div>';
				}				
			}
		}
		
		
		/*
		 * We're processing the payments here, everything about it is in Step 5
		 */
		function process_payment($order_id){
			global $woocommerce;
			
			$order = new WC_Order( $order_id );
			
			if ( version_compare( WOOCOMMERCE_VERSION, '2.1.0', '>=' ) ) {
				/* 2.1.0 */
				$checkout_payment_url = $order->get_checkout_payment_url( true );
			} else {
				/* 2.0.0 */
				$checkout_payment_url = get_permalink( get_option ( 'woocommerce_pay_page_id' ) );
			}

			return array(
				'result' => 'success', 
				'redirect' => add_query_arg(
					'order', 
					$order->id, 
					add_query_arg(
						'key', 
						$order->order_key, 
						$checkout_payment_url						
					)
				)
        	);
		}
 
		/*
		 * In case you need a webhook, like PayPal IPN etc
		 */
		public function check_noqoodypay_response() {
			global $woocommerce;	
			$parsedResult	=	$_REQUEST;
			
			$arr_order_id	=	explode("_",$parsedResult['reference']);
			$order_id 		=	$arr_order_id[0];
			if($order_id != '')
			{
				$order 			= 	new WC_Order( $order_id );
				update_post_meta( $order_id, '_npay_response', $parsedResult );
				if($parsedResult['success'] == 'True')
				{
					$verify_result_url	=	$this->trans_details_url.'?ReferenceNo='.$parsedResult['reference'];
					$access_token		=	$this->get_access_token();
					$context = stream_context_create(array(
						'http' => array(
							'header'  => "Authorization: Bearer " . $access_token
						)
					));
	
					$payment_request	=	 @file_get_contents($verify_result_url, false, $context);
					if($payment_request != '')
					{
						update_post_meta( $order_id, '_npay_response2', $payment_request );
						$arr_reponse	=	json_decode($payment_request,true);
						if(is_array($arr_reponse) && $arr_reponse['success'] == true)
						{
							// we received the payment
							$order->payment_complete();
							$order->reduce_order_stock();
				 
							// some notes to customer (replace true with false to make it private)
							$order->add_order_note( 'Hi, your order is paid! Thank you!', true );					
				 
							// Empty cart
							$woocommerce->cart->empty_cart();
				 
							// Redirect to the thank you page
							$redirect_url = $this->get_return_url( $order );
							wp_redirect( $redirect_url );
							exit;
						}
						else
						{
							$order->add_order_note( __( 'Error', 'woocommerce-gateway-noqoodpay' ) );
							wc_add_notice( __( 'A technical problem prevented us from processing this payment.', 'woocommerce-gateway-noqoodpay' ), $notice_type = 'error' );
							$redirect_url = wc_get_cart_url();				
							wp_redirect( $redirect_url );
							exit;
						}
					}
					else
					{
						$order->add_order_note( __( 'Error in ', 'woocommerce-gateway-noqoodpay' ) );
						wc_add_notice( __( 'Error in payment.'.$arr_reponse['message'], 'woocommerce-gateway-noqoodpay' ), $notice_type = 'error' );
						$redirect_url = wc_get_cart_url();				
						wp_redirect( $redirect_url );
						exit;	
					}
				}
				else
				{
					$order->add_order_note( __( 'Error in ', 'woocommerce-gateway-noqoodpay' ) );
					wc_add_notice( __( 'Error in payment.'.$parsedResult['message'], 'woocommerce-gateway-noqoodpay' ), $notice_type = 'error' );
					$redirect_url = wc_get_cart_url();				
					wp_redirect( $redirect_url );
					exit;	
				}
			} 
	 	}
 	}
}