<?php
/*
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2015 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

use PrestaShop\PrestaShop\Core\Payment\PaymentOption;

if (!defined('_PS_VERSION_')) {
    exit;
}

class Noqoodypay extends PaymentModule
{
    protected $_html = '';
    protected $_postErrors = array();

    public $details;
    public $owner;
    public $address;
    public $extra_mail_vars;

    public function __construct()
    {
        $this->name = 'noqoodypay';
        $this->tab = 'payments_gateways';
        $this->version = '1.0.0';
        $this->ps_versions_compliancy = array('min' => '1.7', 'max' => _PS_VERSION_);
        $this->author = 'Mapweb Technologies';
        $this->controllers = array('validation');
        $this->is_eu_compatible = 1;

        $this->currencies = true;
        $this->currencies_mode = 'checkbox';

        $this->bootstrap = true;
        parent::__construct();

        $this->displayName = $this->l('Noqoodypay');
        $this->description = $this->l('Noqoodypay Payment Gateway');

        if (!count(Currency::checkPaymentCurrencies($this->id))) {
            $this->warning = $this->l('No currency has been set for this module.');
        }
    }

    public function install()
    {
        if (!parent::install() || !$this->registerHook('paymentOptions') || !$this->registerHook('paymentReturn')) {
            return false;
        }
        return true;
    }
	
	public function getContent()
	{
		$output = null;

		if (Tools::isSubmit('submit'.$this->name)) 
		{
			$pay_username 		= 	strval(Tools::getValue('username'));
			$pay_password 		= 	strval(Tools::getValue('password'));
			$pay_project_code 	= 	strval(Tools::getValue('project_code'));
			$pay_secret_key 	= 	strval(Tools::getValue('secret_key'));
			$pay_payment_noqoodypay_live_demo 	= 	strval(Tools::getValue('payment_noqoodypay_live_demo'));

			Configuration::updateValue('username', $pay_username);
			Configuration::updateValue('password', $pay_password);
			Configuration::updateValue('project_code', $pay_project_code);	
			Configuration::updateValue('secret_key', $pay_secret_key);			
			Configuration::updateValue('payment_noqoodypay_live_demo', $pay_payment_noqoodypay_live_demo);				
			$output .= $this->displayConfirmation($this->l('Settings updated'));
		}

		return $output.$this->displayForm();
	}

                // admin settings

    public function displayForm()
	{
		
		// Get default language
		$defaultLang = (int)Configuration::get('PS_LANG_DEFAULT');
	
		// Init Fields form array
		$fieldsForm[0]['form'] = [
			'legend' => [
				'title' => $this->l('Settings'),
			],
			'input' => [
				[
					'type' => 'html',
					'label' => $this->l('Callback URL'),
					'name' => '<a href="#">'.$this->context->link->getModuleLink($this->name, 'validation', array(), true).'?</a><br>Please add this URL at noqoody admin.',					
				],
				[
					'type' => 'text',
					'label' => $this->l('Username'),
					'name' => 'username',
					'size' => 20,
					'required' => true
				],
				[
					'type' => 'text',
					'label' => $this->l('Password'),
					'name' => 'password',
					'size' => 20,
					'required' => true
				],	
				[
					'type' => 'text',
					'label' => $this->l('Project Code'),
					'name' => 'project_code',
					'size' => 20,
					'required' => true
				],
				[
					'type' => 'text',
					'label' => $this->l('Secret Key'),
					'name' => 'secret_key',
					'size' => 20,
					'required' => true
				],
				[
					'type' => 'switch',
						'label' => $this->l('Live Mode'),
						'name' => 'payment_noqoodypay_live_demo',
						'is_bool' => true,
						'desc' => $this->l('Switch to live mode when you are ready to start processing real payments.'),
						'values' => array(
							array(
								'id' => 'live_on',
								'value' => true,
								'label' => $this->l('Live'),
							),
							array(
								'id' => 'live_off',
								'value' => false,
								'label' => $this->l('Test'),
							),
						),
				]
		  
	
			],
			'submit' => [
				'title' => $this->l('Save'),
				'class' => 'btn btn-default pull-right'
			]
		];
	
		$helper = new HelperForm();
	
		// Module, token and currentIndex
		$helper->module = $this;
		$helper->name_controller = $this->name;
		$helper->token = Tools::getAdminTokenLite('AdminModules');
		$helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;
	
		// Language
		$helper->default_form_language = $defaultLang;
		$helper->allow_employee_form_lang = $defaultLang;
	
		// Title and toolbar
		$helper->title = $this->displayName;
		$helper->show_toolbar = true;        // false -> remove toolbar
		$helper->toolbar_scroll = true;      // yes - > Toolbar is always visible on the top of the screen.
		$helper->submit_action = 'submit'.$this->name;
		$helper->toolbar_btn = [
			'save' => [
				'desc' => $this->l('Save'),
				'href' => AdminController::$currentIndex.'&configure='.$this->name.'&save'.$this->name.
				'&token='.Tools::getAdminTokenLite('AdminModules'),
			],
			'back' => [
				'href' => AdminController::$currentIndex.'&token='.Tools::getAdminTokenLite('AdminModules'),
				'desc' => $this->l('Back to list')
			]
		];
	
		// Load current value
		$helper->fields_value['username'] = Configuration::get('username');
		$helper->fields_value['password'] = Configuration::get('password');
		$helper->fields_value['project_code'] = Configuration::get('project_code');
		$helper->fields_value['secret_key'] = Configuration::get('secret_key');		
		$helper->fields_value['payment_noqoodypay_live_demo'] = Configuration::get('payment_noqoodypay_live_demo');
		return $helper->generateForm($fieldsForm);
	}

    public function hookPaymentOptions($params)
    {
        if (!$this->active) {
            return;
        }

        if (!$this->checkCurrency($params['cart'])) {
            return;
        }

        $payment_options = [
            //$this->getOfflinePaymentOption(),
            $this->getExternalPaymentOption(),
            //$this->getEmbeddedPaymentOption(),
            //$this->getIframePaymentOption(),
        ];

        return $payment_options;
    }

    public function checkCurrency($cart)
    {
        $currency_order = new Currency($cart->id_currency);
        $currencies_module = $this->getCurrency($cart->id_currency);

        if (is_array($currencies_module)) {
            foreach ($currencies_module as $currency_module) {
                if ($currency_order->id == $currency_module['id_currency']) {
                    return true;
                }
            }
        }
        return false;
    }

    public function getOfflinePaymentOption()
    {
        $offlineOption = new PaymentOption();
        $offlineOption->setCallToActionText($this->l('Pay offline'))
                      ->setAction($this->context->link->getModuleLink($this->name, 'validation', array(), true))
                      ->setAdditionalInformation($this->context->smarty->fetch('module:noqoodypay/views/templates/front/payment_infos.tpl'))
                      ->setLogo(Media::getMediaPath(_PS_MODULE_DIR_.$this->name.'/payment.jpg'));

        return $offlineOption;
    }

    public function getExternalPaymentOption()
    {
        $externalOption = new PaymentOption();
        $externalOption->setCallToActionText($this->l('Pay by Noqoodypay'))
                       ->setAction($this->context->link->getModuleLink($this->name, 'postprocess', array(), true))
                       ->setInputs([
                            'token' => [
                                'name' =>'token',
                                'type' =>'hidden',
                                'value' =>'12345689',
                            ],
                        ])                       
                       ->setLogo(Media::getMediaPath(_PS_MODULE_DIR_.$this->name.'/payment.jpg'));

        return $externalOption;
    }

    public function getEmbeddedPaymentOption()
    {
        $embeddedOption = new PaymentOption();
        $embeddedOption->setCallToActionText($this->l('Pay embedded'))
                       ->setForm($this->generateForm())
                       ->setAdditionalInformation($this->context->smarty->fetch('module:noqoodypay/views/templates/front/payment_infos.tpl'))
                       ->setLogo(Media::getMediaPath(_PS_MODULE_DIR_.$this->name.'/payment.jpg'));

        return $embeddedOption;
    }

    public function getIframePaymentOption()
    {
        $iframeOption = new PaymentOption();
        $iframeOption->setCallToActionText($this->l('Pay iframe'))
                     ->setAction($this->context->link->getModuleLink($this->name, 'iframe', array(), true))
                     ->setAdditionalInformation($this->context->smarty->fetch('module:noqoodypay/views/templates/front/payment_infos.tpl'))
                     ->setLogo(Media::getMediaPath(_PS_MODULE_DIR_.$this->name.'/payment.jpg'));

        return $iframeOption;
    }

    protected function generateForm()
    {
        $months = [];
        for ($i = 1; $i <= 12; $i++) {
            $months[] = sprintf("%02d", $i);
        }

        $years = [];
        for ($i = 0; $i <= 10; $i++) {
            $years[] = date('Y', strtotime('+'.$i.' years'));
        }

        $this->context->smarty->assign([
            'action' => $this->context->link->getModuleLink($this->name, 'validation', array(), true),
            'months' => $months,
            'years' => $years,
        ]);

        return $this->context->smarty->fetch('module:noqoodypay/views/templates/front/payment_form.tpl');
    }
}
