<?php
/*
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2015 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

/**
 * @since 1.5.0
 */
class NoqoodypayPostProcessModuleFrontController extends ModuleFrontController
{
	private function initclass() {		
		if ( Configuration::get('payment_noqoodypay_live_demo') == 0 ) 
		{
			$this->token_url			= 	'http://151.106.28.182:9222/token';//'http://sandbox.noqoodypay.com/api/token'; // test url
			$this->payment_link_url		= 	'http://151.106.28.182:9222/api/PaymentLink/GenerateLinks'; // test url
			$this->trans_details_url	= 	'http://151.106.28.182:9222/api/Members/GetTransactionDetailStatusByClientReference/'; // test url
		} 
		else 
		{
			$this->token_url 			= 'https://noqoodypay.com/sdk/token'; // live url
			$this->payment_link_url		= 'https://noqoodypay.com/sdk/api/PaymentLink/GenerateLinks/'; // live url
			$this->trans_details_url	= 'https://noqoodypay.com/sdk/api/Members/GetTransactionDetailStatusByClientReference/'; // live url
		}
		$this->npay_username		=	Configuration::get('username');
		$this->npay_password		=	Configuration::get('password');
		$this->npay_project_code	=	Configuration::get('project_code');
		$this->npay_secret_key		=	Configuration::get('secret_key');
	}
	private function get_access_token()
	{	
		$request_headers = array();
		$request_headers[] = 'Accept: application/x-www-formURLencoded';
		
		
		$fields_string	=	'';
		$args = array('grant_type' => 'password',
			'username' => $this->npay_username,
			'password' => $this->npay_password
			);			
		foreach($args as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
		rtrim($fields_string, '&');
		
		// Performing the HTTP request
		$ch = curl_init($this->token_url);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $request_headers);
		curl_setopt($ch,CURLOPT_POST, count($args));
		curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			
		$response_body 	= 	curl_exec($ch); // Performs the Request, with specified curl_setopt() options (if any).		
		if($response_body != '')
		{
			$arr_reponse	=	json_decode($response_body,true);
			if(is_array($arr_reponse) && $arr_reponse['access_token'] != '')
			return $arr_reponse['access_token'];
		}
		return '';
	}
    /**
     * @see FrontController::postProcess()
     */
    public function postProcess()
    {
        $cart = $this->context->cart;
        if ($cart->id_customer == 0 || $cart->id_address_delivery == 0 || $cart->id_address_invoice == 0 || !$this->module->active) {
            Tools::redirect('index.php?controller=order&step=1');
        }

        // Check that this payment option is still available in case the customer changed his address just before the end of the checkout process
        $authorized = false;
        foreach (Module::getPaymentModules() as $module) {
            if ($module['name'] == 'noqoodypay') {
                $authorized = true;
                break;
            }
        }

        if (!$authorized) {
            die($this->module->l('This payment method is not available.', 'validation'));
        }		
		
		$this->initclass();
		
		$access_token	=	$this->get_access_token();
		if($access_token == '')
		{			
			$this->errors[] = $this->module->l('Error in creating token.Please contact site admin!');
			return $this->displayError('');
		}
		else
		{		
			$addressInv = new Address($cart->id_address_invoice);
			
			$order_id		=	$cart->id;
			//$get_payment_link_url	=	$this->payment_link_url.$this->npay_project_code;
			$unq_ref_no		=	$order_id.'_'.time();
			$description	=	Configuration::get('PS_SHOP_NAME')."-Order";
			$amount			=	$cart->getOrderTotal();		
			
			$CustomerName	=	$addressInv->firstname.' '.$addressInv->lastname;			
			$CustomerEmail	=	$this->context->customer->email;
			if($addressInv->phone != '')
			{
				$CustomerMobile	=	$addressInv->phone;
			}
			else
			{
				$CustomerMobile	=	'11';
			}
			$ProjectCode	=	$this->npay_project_code;
			$SecretKey		=	$this->npay_secret_key;
			$string         =   $CustomerEmail.$CustomerName.$CustomerMobile.$description.$ProjectCode.$unq_ref_no; 
			$sig            =   base64_encode(hash_hmac('sha256', $string, $SecretKey, true));
			
			
			/*$fields_string	=	'';
			$args = array('reference' => $unq_ref_no,
				'description' => $description,
				'amount' => $amount,
				'CustomerEmail' => $this->context->customer->email,
				'CustomerMobile' => $addressInv->phone,
				'CustomerName' => $addressInv->firstname.' '.$addressInv->lastname
				);
	
			foreach($args as $key=>$value) { $fields_string .= $key.'='.urlencode($value).'&'; }
			rtrim($fields_string, '&');
			
			$context = stream_context_create(array(
				'http' => array(
					'header'  => "Authorization: Bearer " . $access_token
				)
			));				
			$pmt_lnk_data	= 	@file_get_contents($get_payment_link_url.'?'.$fields_string, false, $context);*/	
			
			$fields_string	=	'';
			$args = array(
				'ProjectCode'    => $ProjectCode,
				'Description'    => $description,
				'Amount'         => $amount,
				'CustomerEmail'  => $CustomerEmail,
				'CustomerMobile' => $CustomerMobile,
				'CustomerName'   => $CustomerName,
				'SecureHash'     => $sig,
				'Reference'      => $unq_ref_no
			);
			foreach($args as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
			$fields_string = rtrim($fields_string, '&');
			
			$request_headers   = array();
			$request_headers[] = 'Accept: application/x-www-formURLencoded';
			$request_headers[] = 'Authorization: Bearer ' . $access_token;
			// Performing the HTTP request
			$ch = curl_init($this->payment_link_url);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $request_headers);
			curl_setopt($ch,CURLOPT_POST, count($args));
			curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
				
			$response_body 	= 	curl_exec($ch); // Performs the Request, with specified curl_setopt() options (if any).	
			$response_err 	= 	curl_error($ch);
			$arr_reponse	=   "";
			$pmt_lnk		=	'';	
			/*echo '<pre>';
			print_r($args);
			print_r($request_headers);
			print_r($response_err);
			print_r($response_body);
			echo '</pre>';*/
			//die;
			
			if($response_body != '')
			{
				$arr_reponse	=	json_decode($response_body,true);
				if(is_array($arr_reponse) && $arr_reponse['PaymentUrl'] != '')
					$pmt_lnk	=	$arr_reponse['PaymentUrl'];
			}
						
			if($pmt_lnk != '')
			{
				//header('Location:'.$pmt_lnk);
				//exit;
				$this->context->smarty->assign([
						'reponse' => $pmt_lnk,
						'success' => true,
					]);
			
				//$this->setTemplate('payment_return.tpl');
				$this->setTemplate('module:noqoodypay/views/templates/front/payment_return.tpl');
			}
			else
			{
				$this->errors[] = $this->module->l("Error in fetching payment links.Please contact site admin!");
				return $this->displayError('');
			}
		}

        // $customer = new Customer($cart->id_customer);
        // if (!Validate::isLoadedObject($customer))
        //     Tools::redirect('index.php?controller=order&step=1');

        // $currency = $this->context->currency;
        // $total = (float)$cart->getOrderTotal(true, Cart::BOTH);
        // $mailVars = array(
        //     '{bankwire_owner}' => Configuration::get('BANK_WIRE_OWNER'),
        //     '{bankwire_details}' => nl2br(Configuration::get('BANK_WIRE_DETAILS')),
        //     '{bankwire_address}' => nl2br(Configuration::get('BANK_WIRE_ADDRESS'))
        // );

        // $this->module->validateOrder($cart->id, Configuration::get('PS_OS_BANKWIRE'), $total, $this->module->displayName, NULL, $mailVars, (int)$currency->id, false, $customer->secure_key);
        // Tools::redirect('index.php?controller=order-confirmation&id_cart='.$cart->id.'&id_module='.$this->module->id.'&id_order='.$this->module->currentOrder.'&key='.$customer->secure_key);
    }
	protected function displayError($message, $description = false)
    {
        array_push($this->errors, $this->module->l($message), $description);
        $this->redirectWithNotifications($this->context->link->getPageLink('order', true, null, array('step' => '3')));
    }
}
