<?php

class ControllerPaymentNoqoodypay extends Controller {
	public function initclass() {
		if ( $this->config->get('noqoodypay_live_demo') == "0" ) 
		{
			$this->token_url			= 	'http://151.106.28.182:9222/token';//'http://sandbox.noqoodypay.com/api/token'; // test url
			$this->payment_link_url		= 	'http://151.106.28.182:9222/api/PaymentLink/GenerateLinks'; // test url
			$this->trans_details_url	= 	'http://151.106.28.182:9222/api/Members/GetTransactionDetailStatusByClientReference/'; // test url
		} 
		else 
		{
			$this->token_url 			= 'https://noqoodypay.com/sdk/token'; // live url
			$this->payment_link_url		= 'https://noqoodypay.com/sdk/api/PaymentLink/GenerateLinks/'; // live url
			$this->trans_details_url	= 'https://noqoodypay.com/sdk/api/Members/GetTransactionDetailStatusByClientReference/'; // live url
		}
		$this->npay_username		=	$this->config->get('noqoodypay_username');
		$this->npay_password		=	$this->config->get('noqoodypay_password');
		$this->npay_project_code	=	$this->config->get('noqoodypay_project_code');
		$this->npay_secret_key		=	$this->config->get('noqoodypay_secret_key');
	}
	private function get_access_token()
	{	
		$request_headers = array();
		$request_headers[] = 'Accept: application/x-www-formURLencoded';
		
		
		$fields_string	=	'';
		$args = array('grant_type' => 'password',
			'username' => $this->npay_username,
			'password' => $this->npay_password
			);
			
		foreach($args as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
		rtrim($fields_string, '&');
		
		// Performing the HTTP request
		$ch = curl_init($this->token_url);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $request_headers);
		curl_setopt($ch,CURLOPT_POST, count($args));
		curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			
		$response_body 	= 	curl_exec($ch); // Performs the Request, with specified curl_setopt() options (if any).		
		if($response_body != '')
		{
			$arr_reponse	=	json_decode($response_body,true);
			if(is_array($arr_reponse) && $arr_reponse['access_token'] != '')
			return $arr_reponse['access_token'];
		}
		return '';
	}
	public function index() {
		$this->initclass();
		$this->load->language('payment/noqoodypay');
		$this->load->model('checkout/order');
		$order_id	=	$this->session->data['order_id'];
		
		$order_info = 	$this->model_checkout_order->getOrder($order_id);
		
		$data['text_connect'] 	= $this->language->get('text_connect');
		$data['text_loading'] 	= $this->language->get('text_loading');
		$data['text_wait'] 		= $this->language->get('text_wait');
		$data['error']			= '';	
		$access_token	=	$this->get_access_token();
		if($access_token == '')
		{
			$data['error']	=	'Error in creating token.Please contact site admin!';
		}
		else
		{		
		
		//$this->npay_username		=	$this->config->get('noqoodypay_username');
		//$this->npay_password		=	$this->config->get('noqoodypay_password');
		//$this->npay_project_code	=	$this->config->get('noqoodypay_project_code');
		//$this->npay_secret_key		=	$this->config->get('noqoodypay_secret_key');
		
			//$get_payment_link_url	=	$this->payment_link_url.$this->npay_project_code;
			$unq_ref_no		=	$order_id.'_'.time();
			$description	=	$order_info['store_name']."-Order";
			$amount			=	$order_info['total'];				
			$CustomerName	=	$order_info['firstname'].' '.$order_info['lastname'];			
			$CustomerEmail	=	$order_info['email'];
			$CustomerMobile	=	$order_info['telephone'];
			$ProjectCode	=	$this->npay_project_code;
			$SecretKey		=	$this->npay_secret_key;
			$string         =   $CustomerEmail.$CustomerName.$CustomerMobile.$description.$ProjectCode.$unq_ref_no; 
			$sig            =   base64_encode(hash_hmac('sha256', $string, $SecretKey, true));
			$fields_string	=	'';
			$args = array(
				'ProjectCode'    => $ProjectCode,
				'Description'    => $description,
				'Amount'         => $amount,
				'CustomerEmail'  => $CustomerEmail,
				'CustomerMobile' => $CustomerMobile,
				'CustomerName'   => $CustomerName,
				'SecureHash'     => $sig,
				'Reference'      => $unq_ref_no
			);
			foreach($args as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
			$fields_string = rtrim($fields_string, '&');
			
			//$this->payment_link_url
			/*$args = array('reference' => $unq_ref_no,
				'description' => $description,
				'amount' => $amount,
				'CustomerEmail' => $order_info['email'],
				'CustomerMobile' => $order_info['telephone'],
				'CustomerName' => $order_info['firstname'].' '.$order_info['lastname']
				);
			
			foreach($args as $key=>$value) { $fields_string .= $key.'='.urlencode($value).'&'; }
			rtrim($fields_string, '&');
			
			
			$context = stream_context_create(array(
				'http' => array(
					'header'  => "Authorization: Bearer " . $access_token
				)
			));				
			$pmt_lnk_data	= 	@file_get_contents($get_payment_link_url.'?'.$fields_string, false, $context);	*/		
			
			$request_headers   = array();
			$request_headers[] = 'Accept: application/x-www-formURLencoded';
			$request_headers[] = 'Authorization: Bearer ' . $access_token;
			// Performing the HTTP request
			$ch = curl_init($this->payment_link_url);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $request_headers);
			curl_setopt($ch,CURLOPT_POST, count($args));
			curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
				
			$response_body 	= 	curl_exec($ch); // Performs the Request, with specified curl_setopt() options (if any).	
			$response_err 	= 	curl_error($ch);
			$arr_reponse	=   "";
			$pmt_lnk		=	'';		
			/*echo '<pre>';
			print_r($request_headers);
			print_r($response_err);
			print_r($response_body);
			echo '</pre>';*/
			
			if($response_body != '')
			{
				$arr_reponse	=	json_decode($response_body,true);
				if(is_array($arr_reponse) && $arr_reponse['PaymentUrl'] != '')
					$pmt_lnk	=	$arr_reponse['PaymentUrl'];
			}
			
			
				
			if($pmt_lnk != '')
			{
				//header('Location: '.$pmt_lnk);
				//exit;
				//Error in fetching payment links.Please contact site admin!				
				$data['success']	=	true;
				$data['reponse']	=	$pmt_lnk;			
			}
			else
			{
				$data['success']	=	'';
				$data['error']	=	"Error in fetching payment links.Please contact site admin!";
			}
		}			
    	$data['button_confirm'] = $this->language->get('button_confirm');
		
		return $this->load->view($this->config->get('config_template') . '/template/payment/noqoodypay.tpl', $data);
		
		
		//return $this->load->view('extension/payment/noqoodypay', $data);
	}
	public function callback() {
		if ($this->session->data['payment_method']['code'] == 'noqoodypay') {
			$this->initclass();
			$this->load->language('payment/noqoodypay');

			$this->document->setTitle($this->language->get('text_title'));
			
			$data['heading_title'] = $this->language->get('text_title');
			$data['results'] = "";
			
			$data['breadcrumbs'] = array();
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_home'), 
				'href' => $this->url->link('common/home', '', true)
			);
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_title'), 
				'href' => $this->url->link('payment/noqoodypay/callback', '', true)
			);

			try {				
				$arr_order_id	=	explode("_",$this->request->get['reference']);
				$order_id 		=	$arr_order_id[0];
				if($order_id != '')
				{
					$this->load->model('checkout/order');
					$order_info = $this->model_checkout_order->getOrder($order_id);
	
					if (!$order_info)
						throw new Exception($this->language->get('error_order_id'));
					if($this->request->get['success'] == 'True')
					{
						$verify_result_url	=	$this->trans_details_url.'?ReferenceNo='.$this->request->get['reference'];
						$access_token		=	$this->get_access_token();
						$context = stream_context_create(array(
							'http' => array(
								'header'  => "Authorization: Bearer " . $access_token
							)
						));
		
						$payment_request	=	 @file_get_contents($verify_result_url, false, $context);
						if($payment_request != '')
						{
							//update_post_meta( $order_id, '_npay_response2', $payment_request );
							$arr_reponse	=	json_decode($payment_request,true);
							if(is_array($arr_reponse) && $arr_reponse['success'] == true)
							{
								$trackId	=	$arr_reponse['TransactionID'];
								$comment = $this->language->get('text_results') . $trackId;
								$this->model_checkout_order->addOrderHistory($order_id, $this->config->get('noqoodypay_order_status_id'), $comment, true);
			
								$data['error_warning'] = NULL;
								$data['results'] = $trackId;
								$data['button_continue'] = $this->language->get('button_complete');
								$data['continue'] = $this->url->link('checkout/success');
								$data['text_results'] = $this->language->get('text_results');
							}
							else
							{
								throw new Exception($arr_reponse['message']);								
							}
						}
						else
						{
							throw new Exception('A technical problem prevented us from processing this payment.');	
						}	
					}
					else
					{
						throw new Exception('Error in payment.'.$this->request->get['message']);
					}					
				}
				else
				{
					throw new Exception('Invalid Order');
				}
			} catch (Exception $e) {
				$data['error_warning'] = $e->getMessage();
				$data['button_continue'] = $this->language->get('button_view_cart');
				$data['continue'] = $this->url->link('checkout/cart');
			}

			$data['column_left'] = $this->load->controller('common/column_left');
			$data['column_right'] = $this->load->controller('common/column_right');
			$data['content_top'] = $this->load->controller('common/content_top');
			$data['content_bottom'] = $this->load->controller('common/content_bottom');
			$data['footer'] = $this->load->controller('common/footer');
			$data['header'] = $this->load->controller('common/header');

			//$this->response->setOutput($this->load->view($this->config->get('config_template') . '/template/payment/noqoodypay_confirm.tpl', $data));
			$this->response->redirect($this->url->link('checkout/success', '', 'SSL'));
			//return $this->load->view($this->config->get('config_template') . '/template/payment/noqoodypay.tpl', $data);
		}
	}
}
?>
