<?php
class ControllerPaymentNoqoodypay extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('payment/noqoodypay');

		$this->document->setTitle(strip_tags($this->language->get('heading_title')));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('noqoodypay', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'));
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['username'])) {
			$data['error_username'] = $this->error['username'];
		} else {
			$data['error_username'] = '';
		}
		if (isset($this->error['password'])) {
			$data['error_password'] = $this->error['password'];
		} else {
			$data['error_password'] = '';
		}
		if (isset($this->error['project-code'])) {
			$data['error_project_code'] = $this->error['project-code'];
		} else {
			$data['error_project_code'] = '';
		}
		
		if (isset($this->error['secret-key'])) {
			$data['error_secret_key'] = $this->error['secret-key'];
		} else {
			$data['error_secret_key'] = '';
		}
		

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('extension/payment', 'token=' . $this->session->data['token'] . '&type=payment', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('payment/noqoodypay', 'token=' . $this->session->data['token'], true)
		);

		$data['action'] = $this->url->link('payment/noqoodypay', 'token=' . $this->session->data['token'], true);

		$data['cancel'] = $this->url->link('marketplace/extension', 'token=' . $this->session->data['token'] . '&type=payment', true);

		if (isset($this->request->post['noqoodypay_username'])) {
			$data['noqoodypay_username'] = $this->request->post['noqoodypay_username'];
		} else {
			$data['noqoodypay_username'] = $this->config->get('noqoodypay_username');
		}
		
		if (isset($this->request->post['noqoodypay_password'])) {
			$data['noqoodypay_password'] = $this->request->post['noqoodypay_password'];
		} else {
			$data['noqoodypay_password'] = $this->config->get('noqoodypay_password');
		}
		
		if (isset($this->request->post['noqoodypay_project_code'])) {
			$data['noqoodypay_project_code'] = $this->request->post['noqoodypay_project_code'];
		} else {
			$data['noqoodypay_project_code'] = $this->config->get('noqoodypay_project_code');
		}
		
		if (isset($this->request->post['noqoodypay_secret_key'])) {
			$data['noqoodypay_secret_key'] = $this->request->post['noqoodypay_secret_key'];
		} else {
			$data['noqoodypay_secret_key'] = $this->config->get('noqoodypay_secret_key');
		}
		
		
		if (isset($this->request->post['noqoodypay_live_demo'])) {
			$data['noqoodypay_live_demo'] = $this->request->post['noqoodypay_live_demo'];
		} else {
			$data['noqoodypay_live_demo'] = $this->config->get('noqoodypay_live_demo');
		}

		if (isset($this->request->post['noqoodypay_direct'])) {
			$data['noqoodypay_direct'] = $this->request->post['noqoodypay_direct'];
		} else {
			$data['noqoodypay_direct'] = $this->config->get('noqoodypay_direct');
		}

		if (isset($this->request->post['noqoodypay_order_status_id'])) {
			$data['noqoodypay_order_status_id'] = $this->request->post['noqoodypay_order_status_id'];
		} else {
			$data['noqoodypay_order_status_id'] = $this->config->get('noqoodypay_order_status_id');
		}
		$this->load->model('localisation/order_status');

		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		if (isset($this->request->post['noqoodypay_status'])) {
			$data['noqoodypay_status'] = $this->request->post['noqoodypay_status'];
		} else {
			$data['noqoodypay_status'] = $this->config->get('noqoodypay_status');
		}

		if (isset($this->request->post['noqoodypay_sort_order'])) {
			$data['noqoodypay_sort_order'] = $this->request->post['noqoodypay_sort_order'];
		} else {
			$data['noqoodypay_sort_order'] = $this->config->get('noqoodypay_sort_order');
		}
		//get lang data
		
		// Heading
		$data['heading_title']       = $this->language->get('heading_title'); 
		
		// Text 
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_extension']	  = $this->language->get('text_extension'); 
		$data['text_success']        = $this->language->get('text_success'); 
		$data['text_noqoodypay']  	  = $this->language->get('text_noqoodypay'); 
		$data['text_edit']           = $this->language->get('text_edit'); 
		$data['text_support']        = $this->language->get('text_support'); 
		$data['text_support_title']  = $this->language->get('text_support_title'); 
		$data['text_live']			  = $this->language->get('text_live'); 
		$data['text_demo']			  = $this->language->get('text_demo'); 
		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');
		// Entry
		$data['entry_username']   	  = $this->language->get('entry_username'); 
		$data['entry_password']   	  = $this->language->get('entry_password'); 
		$data['entry_project_code']  = $this->language->get('entry_project_code'); 
		$data['entry_secret_key']  = $this->language->get('entry_secret_key'); 
		
		$data['entry_live_demo']	  = $this->language->get('entry_live_demo'); 
		$data['entry_order_status']  = $this->language->get('entry_order_status'); 
		$data['entry_status']        = $this->language->get('entry_status'); 
		$data['entry_sort_order']    = $this->language->get('entry_sort_order'); 
		
		// Error
		//$data['error_permission']    = $this->language->get('error_permission'); 
		//$data['error_username']   	  = $this->language->get('error_username'); 
		//$data['error_password']  	  = $this->language->get('error_password'); 
		//$data['error_project-code']  = $this->language->get('error_project-code'); 


		$data['call_back_url'] = HTTPS_CATALOG.'noqoodypay_callback.php?';		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('payment/noqoodypay.tpl', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'payment/noqoodypay')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if (!$this->request->post['noqoodypay_username']) {
			$this->error['username'] = $this->language->get('error_username');
		}
		if (!$this->request->post['noqoodypay_password']) {
			$this->error['password'] = $this->language->get('error_password');
		}
		if (!$this->request->post['noqoodypay_project_code']) {
			$this->error['project-code'] = $this->language->get('error_project-code');
		}
		if (!$this->request->post['noqoodypay_secret_key']) {
			$this->error['secret-key'] = $this->language->get('error_secret_key');
		}

		return !$this->error;
	}
}
?>