<?php
/**
 * Copyright © 2015 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Gateway\Noqoodypay\Model;

use Magento\Quote\Api\Data\CartInterface;
use Magento\Payment\Model\Method\AbstractMethod;
use Gateway\Noqoodypay\Model\Config\Source\Order\Status\Paymentreview;
use Magento\Sales\Model\Order;


/**
 * Pay In Store payment method model
 */
class Noqoodypay extends AbstractMethod
{
    /**
     * @var bool
     */
    protected $_isInitializeNeeded = true;

    /**
     * Payment code
     *
     * @var string
     */
    protected $_code = 'noqoodypay';

    /**
     * Availability option
     *
     * @var bool
     */
    protected $_isOffline = true;

    /**
     * Payment additional info block
     *
     * @var string
     */
    protected $_formBlockType = 'Gateway\Noqoodypay\Block\Form\Noqoodypay';

    /**
     * Sidebar payment info block
     *
     * @var string
     */
    protected $_infoBlockType = 'Magento\Payment\Block\Info\Instructions';

    protected $_gateUrl = "https://noqoodypay.com/api/api/Members/GetPaymentLinks/";
    
    protected $_testUrl = "https://sandbox.noqoodypay.com/api/api/Members/GetPaymentLinks/";

    protected $_test;

    protected $orderFactory;

    /**
     * Get payment instructions text from config
     *
     * @return string
     */
    public function getInstructions()
    {
        return trim($this->getConfigData('instructions'));
    }

    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Api\ExtensionAttributesFactory $extensionFactory,
        \Magento\Framework\Api\AttributeValueFactory $customAttributeFactory,
        \Magento\Payment\Helper\Data $paymentData,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Payment\Model\Method\Logger $logger,
        \Magento\Framework\Module\ModuleListInterface $moduleList,
        \Magento\Framework\Stdlib\DateTime\TimezoneInterface $localeDate,
        \Magento\Sales\Model\OrderFactory $orderFactory,
        \Magento\Framework\App\RequestInterface $request,
        \Magento\Checkout\Model\Session $checkoutSession,
        \Magento\Framework\Model\ResourceModel\AbstractResource $resource = null,
        \Magento\Framework\Data\Collection\AbstractDb $resourceCollection = null,
        array $data = []){
        $this->orderFactory = $orderFactory;
        $this->_request = $request;
        $this->_checkoutSession = $checkoutSession;
        parent::__construct($context,
            $registry,
            $extensionFactory,
            $customAttributeFactory,
            $paymentData,
            $scopeConfig,
            $logger,
            $resource,
            $resourceCollection,
            $data);
    }


    //@param \Magento\Framework\Object|\Magento\Payment\Model\InfoInterface $payment
    public function getAmount($orderId)//\Magento\Framework\Object $payment)
    {   //\Magento\Sales\Model\OrderFactory
        $orderFactory=$this->orderFactory;
        /** @var \Magento\Sales\Model\Order $order */
        // $order = $payment->getOrder();
        // $order->getIncrementId();
        /* @var $order \Magento\Sales\Model\Order */

            $order = $orderFactory->create()->loadByIncrementId($orderId);
            //$payment= $order->getPayment();

        // return $payment->getAmount();
        return $order->getGrandTotal();
    }

    protected function getOrder($orderId)
    {
        $orderFactory=$this->orderFactory;
        return $orderFactory->create()->loadByIncrementId($orderId);

    }

    /**
     * Set order state and status
     *
     * @param string $paymentAction
     * @param \Magento\Framework\Object $stateObject
     * @return void
     */
    public function initialize($paymentAction, $stateObject)
    {
        $state = $this->getConfigData('order_status');
        $this->_gateUrl=$this->getConfigData('cgi_url');
        $this->_testUrl=$this->getConfigData('cgi_url_test_mode');
        $this->_test=$this->getConfigData('test');
        $stateObject->setState($state);
        $stateObject->setStatus($state);
        $stateObject->setIsNotified(false);
    }

    /**
     * Check whether payment method can be used
     *
     * @param CartInterface|null $quote
     * @return bool
     */
    public function isAvailable(\Magento\Quote\Api\Data\CartInterface $quote = null)
    {
        if ($quote === null) {
            return false;
        }
        return parent::isAvailable($quote) && $this->isCarrierAllowed(
            $quote->getShippingAddress()->getShippingMethod()
        );
    }

    public function getGateUrl(){
        if($this->getConfigData('test')){
            return $this->_testUrl;
        }else{
            return $this->_gateUrl;
        }
    }

    /**
     * Check whether payment method can be used with selected shipping method
     *
     * @param string $shippingMethod
     * @return bool
     */
    protected function isCarrierAllowed($shippingMethod)
    {
        return strpos($this->getConfigData('allowed_carrier'), $shippingMethod) !== true;
    }


    public function ipn_hash_varify($store_passwd="", $data="") 
    {
        if(isset($data) && isset($data['verify_sign']) && isset($data['verify_key'])) 
        {
            # NEW ARRAY DECLARED TO TAKE VALUE OF ALL POST
            $pre_define_key = explode(',', $data['verify_key']);
            $new_data = array();
            if(!empty($pre_define_key )) 
            {
                foreach($pre_define_key as $value) 
                {
                    if(isset($data[$value])) 
                    {
                        $new_data[$value] = ($data[$value]);
                    }
                }
            }
            # ADD MD5 OF STORE PASSWORD
            $new_data['store_passwd'] = ($store_passwd);
            # SORT THE KEY AS BEFORE
            ksort($new_data);
            $hash_string="";
            foreach($new_data as $key=>$value) { $hash_string .= $key.'='.($value).'&'; }
            $hash_string = rtrim($hash_string,'&');
            if(md5($hash_string) == $data['verify_sign']) 
            {
                return true;
            } 
            else 
            {
                return false;
            }
        } 
        else 
            return false;
    }

    public function ipnAction($postData){
		
        $password = md5($this->getConfigData('pass_word_1'));
        $result = "No Result";
        if($this->_request->getPost())
        {
            if($this->ipn_hash_varify($password, $postData)) 
            {
                $result = "Hash validation success.";
            }
            else 
            {
                $result = "Hash validation failed.";
            }
        }
        echo $result;
    }

    public function get_access_token($post_data,$direct_api_url) {
		$request_headers = array();
			$request_headers[] = 'Accept: application/x-www-formURLencoded';
			
			$fields_string	=	'';
			$args = array('grant_type' => 'password',
				'username' => $post_data['username'],
				'password' => $post_data['password']
			);
			
			foreach($args as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
			rtrim($fields_string, '&');
	
		$ch = curl_init($direct_api_url);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $request_headers);
		curl_setopt($ch, CURLOPT_POST, count($args));
		curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		
		$response_body 	= 	curl_exec($ch); // Performs the Request, with specified curl_setopt() options (if any).			
		if($response_body != '')
		{
			$arr_reponse	=	json_decode($response_body,true);
			if(is_array($arr_reponse) && $arr_reponse['access_token'] != '')
			return $arr_reponse['access_token'];
		}
		return '';
	}
	
	public function getPayementLinks($payment_link_url, $token, $project_code, $description, $amount, $CustomerEmail, $CustomerMobile, $CustomerName, $Secret, $Reference) {
	   {
			$string         =   $CustomerEmail.$CustomerName.$CustomerMobile.$description.$project_code.$Reference; 
			$sig            =   base64_encode(hash_hmac('sha256', $string, $Secret, true));
			$fields_string	=	'';
			$args = array(
				'ProjectCode'    => $project_code,
				'Description'    => $description,
				'Amount'         => $amount,
				'CustomerEmail'  => $CustomerEmail,
				'CustomerMobile' => $CustomerMobile,
				'CustomerName'   => $CustomerName,
				'SecureHash'     => $sig,
				'Reference'      => $Reference
			);
			foreach($args as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
			$fields_string = rtrim($fields_string, '&');
	
			$request_headers   = array();
			$request_headers[] = 'Accept: application/x-www-formURLencoded';
			$request_headers[] = 'Authorization: Bearer ' . $token;
			// Performing the HTTP request
			$ch = curl_init($payment_link_url);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $request_headers);
			curl_setopt($ch,CURLOPT_POST, count($args));
			curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
				
			$response_body 	= 	curl_exec($ch); // Performs the Request, with specified curl_setopt() options (if any).	
			$response_err 	= 	curl_error($ch);
			$arr_reponse	=   "";
			if($response_body != '')
			{
				$arr_reponse	=	json_decode($response_body,true);
				if(is_array($arr_reponse) && $arr_reponse['PaymentUrl'] != '')
				return $arr_reponse['PaymentUrl'];
			}
			return '';
		}
		return '';
    }
    public function getPostData($orderId)
    {   
        //Get Object Manager Instance
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $order = $objectManager->create('Magento\Sales\Model\Order')->loadByIncrementId($orderId); //Use increment id here.
        //$order->getCustomerName(); 
        $_objectManager = \Magento\Framework\App\ObjectManager::getInstance(); //instance of\Magento\Framework\App\ObjectManager
        $storeManager = $_objectManager->get('Magento\Store\Model\StoreManagerInterface'); 
        //$currentStore = $storeManager->getStore();
        //$baseUrl = $storeManager->getStore()->getBaseUrl();
		
		if ($this->getConfigData('test')) {
            $direct_api_url     = "http://151.106.28.182:9222/token";
			$trans_details_url	= 'http://151.106.28.182:9222/api/Members/GetTransactionDetailStatusByClientReference/'; // test url
			$payment_link_url	= 'http://151.106.28.182:9222/api/PaymentLink/GenerateLinks'; // test url
        }
        else{
            $direct_api_url         = "https://noqoodypay.com/sdk/token";
			$trans_details_url	    = 'https://noqoodypay.com/sdk/api/Members/GetTransactionDetailStatusByClientReference/'; // live url
			$payment_link_url		= 'https://noqoodypay.com/sdk/api/PaymentLink/GenerateLinks/'; // live url
        }
    
    
    
        $PostData						=	array();
		$post_data 						= 	array();
        $PostData['OutSum']				=	round($this->getAmount($orderId), 2);
        $PostData['InvId']				=	intval($orderId);
    
		$post_data['username']		    =	$this->getConfigData('testmode_username');
		$post_data['password']		    =	$this->getConfigData('testmode_password');
		$post_data['pay_project_code']	=	$this->getConfigData('testmode_projectcode');
		$post_data['secret_key']        =	$this->getConfigData('testmode_secretkey');
				
		$post_data['order_id'] 			 = $orderId;
		$post_data['bill_amount']		 = round($this->getAmount($orderId), 2);

        $post_data['success_url']	=	$storeManager->getStore()->getBaseUrl().'noqoodypay/payment/response';
        $post_data['fail_url']		=	$storeManager->getStore()->getBaseUrl().'noqoodypay/payment/fail';
        $post_data['cancel_url']	=	$storeManager->getStore()->getBaseUrl().'noqoodypay/payment/cancel';
		$PostData['token']          =   $this->get_access_token($post_data,$direct_api_url); 
		if($PostData['token'] == '')
		{
			echo "Error in creating token.Please contact site admin!";
			exit;
		} else
		{	
		    $token                           =  $PostData['token']; 
			$project_code                    =  $post_data['pay_project_code'];
		    $unq_ref_no						 =	$orderId.'_'.time();
			$description					 =	$storeManager->getStore()->getName()."-Order";
			$amount							 =	$post_data['bill_amount'];
			$CustomerEmail                   =  $order->getCustomerEmail();
			$CustomerMobile                  =  $order->getBillingAddress()->getTelephone();
			$CustomerName                    =  $order->getCustomerName();
			$Secret                          =  $post_data['secret_key'];
		    $paymentUrl = $this->getPayementLinks($payment_link_url, $token, $project_code, $description, $amount, $CustomerEmail, $CustomerMobile, $CustomerName, $Secret, $unq_ref_no);
			$PostData['token_elements']      =  ""; 	
			if($paymentUrl != '')
			{
				$PostData['token_elements'] .= '<div id="noqoodypay">';
				$PostData['token_elements'] .=  '<input checked="checked" type="radio" style="display:none;" name="pmt_option" value="'.$paymentUrl.'" id="pmt_option" onclick="add_action(this.value)" />&nbsp;<br>';
				$PostData['token_elements'] .=  '<input type="hidden" value="" id="redirect_url">';
				$PostData['token_elements'] .=  '<BR /><input type="button" name="Pay_Now" value="Pay Now" class="action primary continue button alt" id="eazypay-payment-button" onclick="return check_payment_form();"></div>';
			}
			else
			{
				echo "Error in fetching payment links.Please contact site admin!";
				exit;	
			}
		}

		$html = "<!doctype html>";
		$html .= "<title>NoQoodyPay Payment Gateway</title>";
		$html .= "<style>";
		$html .= " body { text-align: center; padding: 150px; }";
		$html .= " h1 { font-size: 50px; }";
		$html .= " body { font: 20px Helvetica, sans-serif; color: #333; }";
		$html .= " article { display: block; text-align: left; width: 650px; margin: 0 auto; }";
		$html .= " a { color: #dc8100; text-decoration: none; }";
		$html .= " a:hover { color: #333; text-decoration: none; }";
		$html .= " .action {
			background-image: none;
			background: #1979c3;
			border: 1px solid #1979c3;
			color: #fff;
			cursor: pointer;
			display: inline-block;
			font-family: 'Open Sans','Helvetica Neue',Helvetica,Arial,sans-serif;
			font-weight: 600;
			padding: 7px 15px;
			font-size: 1.4rem;
			box-sizing: border-box;
			vertical-align: middle;
		}";
		$html .= " </style>";
		
		$html .= " <article>";
		$html .= " <h2>Redirecting to NoQoodyPay Payment Gateway.....</h1>";
		//$html .= " <h3>Please Select One Of Following Payment Option!</h3>";
		$html .= " <div>";
		$html .= " <p><form action='' method='POST' name='mygatewayform' id='mygatewayform'>";
		$html .=  $PostData['token_elements'];
		$html .= " </form></p>";
		
		$html .= " <script>";
		$html .= " function check_payment_form()
		{
			var redirect_uri	=	document.getElementById('redirect_url').value;
			if(redirect_uri == '')
			{
				alert('Please select payment option');
				return false;
			}
			document.getElementById('mygatewayform').action	= redirect_uri;
			location.href	=	redirect_uri;
		}
		function add_action(frm_action)
		{
			document.getElementById('redirect_url').value   = frm_action;
			document.getElementById('mygatewayform').action	= frm_action;
		}
		document.getElementById('pmt_option').click();
		document.getElementById('eazypay-payment-button').click();
		</script>";

		$html .= " </div>";
		$html .= " </article>";
        die($html);
        return $PostData;
    }

    public function responseAction($response)
    {
		$parsedResult	=	$_REQUEST;
		if ($this->getConfigData('test')) {
            $direct_api_url     = "http://151.106.28.182:9222/token";
			$trans_details_url  = 'http://151.106.28.182:9222/api/Members/GetTransactionDetailStatusByClientReference/';	
        }
        else{
            $direct_api_url     = "https://noqoodypay.com/sdk/token";
			$trans_details_url	= 'https://noqoodypay.com/sdk/api/Members/GetTransactionDetailStatusByClientReference/';
        }
		
		$arr_order_id	=	explode("_",$parsedResult['reference']);
		$order_id 		=	$arr_order_id[0];
		if($order_id != '')
		{
			$objectManager = \Magento\Framework\App\ObjectManager::getInstance();
			$order = $objectManager->create('Magento\Sales\Model\Order')->loadByIncrementId($order_id);
			if($parsedResult['success'] == 'True')
			{
				$verify_result_url	=	$trans_details_url.'?ReferenceNo='.$parsedResult['reference'];
				$post_data          =   array();  
				$post_data['username']		    =	$this->getConfigData('testmode_username');
		        $post_data['password']		    =	$this->getConfigData('testmode_password');
				$access_token					=	$this->get_access_token($post_data,$direct_api_url);
				//exit;
				$context = stream_context_create(array(
					'http' => array(
						'header'  => "Authorization: Bearer " . $access_token
					)
				));
				$payment_request	 =	 @file_get_contents($verify_result_url, false, $context);				
				if($payment_request != '')
				{
					$arr_reponse	=	json_decode($payment_request,true);
					if(is_array($arr_reponse) && $arr_reponse['success'] == true) //TransactionStatus
					{
						$orderState = Order::STATE_PROCESSING;
						$order->setState($orderState, true, 'Noqoodypay Gateway has authorized the payment.')->setStatus($orderState);
						$order->save();
						return true;
					}
					else
					{
						$orderState = Order::STATE_HOLDED;
						$order->setState($orderState, true, $risk_title)>setStatus($orderState);
						$order->save();
						return false;
					}
				} else 
				{
					// There is a problem in the response we got
					$this->errorAction();
					return false;
				}
			} else 
            {
				//die(' In Response Action Function.11....');
                // There is a problem in the response we got
                $this->errorAction();
				return false;
            }
		}
    }
    
    public function getPaymentMethod()
    {
        $orderId = $this->_checkoutSession->getLastRealOrderId();
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $order = $objectManager->create('Magento\Sales\Model\Order')->loadByIncrementId($orderId);
        $payment = $order->getPayment();
        $method = $payment->getMethodInstance();
        $methodTitle = $method->getTitle();
        
        return $methodTitle;
    }

    public function getConfigPaymentData()
    {
        return $this->getConfigData('title');
    }
    
    public function getCusMail()
    {
        $orderId = $this->_checkoutSession->getLastRealOrderId();
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $order = $objectManager->create('Magento\Sales\Model\Order')->loadByIncrementId($orderId);

        $PostData['order_id'] = $orderId;
        $PostData['cus_email'] = $order->getCustomerEmail();
        $PostData['url'] = $this->getConfigData('test');
        $PostData['total_amount'] = round($this->getAmount($orderId), 2); 
        $PostData['cus_name'] = $order->getCustomerName();
        $PostData['cus_phone'] = $order->getBillingAddress()->getTelephone();
        $PostData['title'] = $this->getConfigData('title');
        $PostData['full_name'] = $order->getBillingAddress()->getFirstname()." ".$order->getBillingAddress()->getLastname();
        $PostData['country'] = $order->getBillingAddress()->getCountryId();
        
        // $PostData['company'] = $order->getBillingAddress()->getCompany();
        $PostData['street'] = $order->getBillingAddress()->getStreet();
        $PostData['region'] = $order->getBillingAddress()->getRegionId();
        $PostData['city'] = $order->getBillingAddress()->getCity().", ".$order->getBillingAddress()->getPostcode();
        $PostData['telephone'] = $order->getBillingAddress()->getTelephone();

        return $PostData;
    }

    public function errorAction()
    {
        $orderId = $this->_checkoutSession->getLastRealOrderId();
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $order = $objectManager->create('Magento\Sales\Model\Order')->loadByIncrementId($orderId);
        $_objectManager = \Magento\Framework\App\ObjectManager::getInstance();

        $orderState = Order::STATE_CANCELED;
        $order->setState($orderState, true, 'Gateway has declined the payment.')->setStatus($orderState);
        $order->save(); 
    }
    
    public function getSuccessMsg()
    {
        $orderId = $this->_checkoutSession->getLastRealOrderId();
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $order = $objectManager->create('Magento\Sales\Model\Order')->loadByIncrementId($orderId);
        $_objectManager = \Magento\Framework\App\ObjectManager::getInstance(); 
        $storeManager = $_objectManager->get('Magento\Store\Model\StoreManagerInterface'); 
        
        $PostData=[];
        $PostData['cus_name'] = $order->getCustomerName();   
        $PostData['cus_email'] = $order->getCustomerEmail();
        // $PostData['cus_phone'] = $order->getBillingAddress()->getTelephone();  
        $PostData['total_amount'] = round($this->getAmount($orderId), 2); 
        $PostData['tran_id'] = $orderId;
        $PostData['state'] = $order->getState(); 

        return $PostData;
    }
}
